' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Produkt class defines the default behavior for all products in the WebShop.
''' </summary>
Public Class Product

#Region "Zmienne prywatne"

  Private _id As Integer = -1
  Private _title As String = String.Empty
  Private _description As String = String.Empty
  Private _price As Decimal = 0
  Private _categoryId As Integer = -1
  Private _pictureUrlSmall As String = String.Empty
  Private _pictureUrlMedium As String = String.Empty
  Private _pictureUrlLarge As String = String.Empty

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Domylny konstruktor for Produkt class.
  ''' </summary>
  Public Sub New()
  End Sub

  ''' <summary>
  ''' Domylny konstruktor used to create an entirely new product.
  ''' </summary>
  Public Sub New(ByVal productId As Integer, ByVal theCategoryId As Integer)
    Me._id = productId
    Me._categoryId = theCategoryId
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Unikalny identyfikator of produkt.
  ''' </summary>
  Public Property Id() As Integer
    Get
      Return _id
    End Get
    Set(ByVal value As Integer)
      _id = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera or sets the title of the ordered product w bazie danych. Is used to display quick info about Produkt.
  ''' For example, koszyk can display this title as a tooltip on the thumb for each ordered product.
  ''' </summary>
  Public Property Title() As String
    Get
      Return _title
    End Get

    Set(ByVal Value As String)
      _title = Value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera or sets the description of the ordered product w bazie danych. Is used to display detailed info about Produkt.
  ''' </summary>
  Public Property Description() As String
    Get
      Return _description
    End Get

    Set(ByVal Value As String)
      _description = Value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera or sets the price of a single item.
  ''' </summary>
  Public Property Price() As Decimal
    Get
      Return _price
    End Get

    Set(ByVal Value As Decimal)
      _price = Value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera or sets the type of Produkt.
  ''' </summary>
  Public Property CategoryId() As Integer
    Get
      Return _categoryId
    End Get
    Set(ByVal value As Integer)
      _categoryId = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera or sets the Full Url for the small picture of this product. This picture is used in koszyk View.
  ''' </summary>
  Public Property PictureUrlSmall() As String
    Get
      Return _pictureUrlSmall
    End Get

    Set(ByVal Value As String)
      _pictureUrlSmall = Value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera or sets  the Full Url for the medium picture of this product. This picture is used on product list pages.
  ''' </summary>
  Public Property PictureUrlMedium() As String
    Get
      Return _pictureUrlMedium
    End Get

    Set(ByVal Value As String)
      _pictureUrlMedium = Value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera or sets the Full Url for the large picture of this product. This picture is used on Produkts Detail page.
  ''' </summary>
  Public Property PictureUrlLarge() As String
    Get
      Return _pictureUrlLarge
    End Get

    Set(ByVal Value As String)
      _pictureUrlLarge = Value
    End Set
  End Property

#End Region

End Class
